ORCA/M Asm65816 2.1.0

0001 E62A                       TITLE ', SEGMENTS.a - Load_Segment'
0002 E62A              *
0003 E62A              ****************************************************************
0004 E62A              *
0005 E62A              *              Load a Segment
0006 E62A              *
0007 E62A              *  Inputs:     User ID                         (TOS+7)
0008 E62A              *              Load File Number                (TOS+5)
0009 E62A              *              Load Segment Number             (TOS+3)
0010 E62A              *
0011 E62A              *  Outputs:    Segment Address                 (TOS+9)
0012 E62A              *              A - status
0013 E62A              *              C - set if error occurred
0014 E62A              *
0015 E62A              *  Zero Page used: TempZero, Handle
0016 E62A              *
0017 E62A              ****************************************************************
0018 E62A              *
0019 E62A              Load_Segment PROC 
0020 E62A                       with DirectPage, Globals
0021 E62A
0022 E62A              OAddress equ   9
0023 E62A              IUserID  equ   7
0024 E62A              IFileNum equ   5
0025 E62A              ISegNum  equ   3
0026 E62A              ;
0027 E62A              ;        look in Memory Segment Table for segment
0028 E62A              ;
0029 E62A A9 00 00              lda   #0
0030 E62D 48                    pha                            ;output Handle
0031 E62E 48                    pha   
0032 E62F A3 0B                 lda   IUserID+4,s              ;UserID
0033 E631 48                    pha   
0034 E632 A3 0B                 lda   IFileNum+6,s             ;Load File Number
0035 E634 48                    pha   
0036 E635 A3 0B                 lda   ISegNum+8,s              ;Load Segment Number
0037 E637 48                    pha   
0038 E638 20 6E F8              jsr   Find_MemSeg
0039 E63B 68                    pla   
0040 E63C 85 08                 sta   Handle                   ;output Handle
0041 E63E 68                    pla   
0042 E63F 85 0A                 sta   Handle+2
0043 E641 BD 0A 00              lda   |MS_Handle,x             ;save handle to Load Segment
0044 E644 85 00                 sta   TempZero
0045 E646 BD 0C 00              lda   |MS_Handle+2,x
0046 E649 85 02                 sta   TempZero+2
0047 E64B 4B                    phk                            ;restore DBR
0048 E64C AB                    plb   
0049 E64D
0050 E64D B0 34                 bcs   cont1                    ;check if segment actually found
0051 E64F              ;
0052 E64F              ;        found segment in Memory Segment Table, lock it
0053 E64F              ;
0054 E64F D4 02                 pei   TempZero+2               ;Handle
0055 E651 D4 00                 pei   TempZero
0056 E653 A2 02 20 22           _HLock 
0057 E65A              ;
0058 E65A              ;        now check to see if it is really in memory
0059 E65A              ;
0060 E65A A5 00                 lda   TempZero
0061 E65C 05 02                 ora   TempZero+2
0062 E65E F0 16                 beq   cont0
0063 E660 A5 00                 lda   TempZero                 ;handle to load segment
0064 E662 A4 02                 ldy   TempZero+2
0065 E664 20 D6 FA              jsr   DeRef                    ;dereference handle
0066 E667 90 32                 bcc   found                    ;A,Y now contains address
0067 E669              ;
0068 E669              ;        segment is not in memory, dispose of the handle in the
0069 E669              ;        Memory Segment Table entry
0070 E669              ;
0071 E669 D4 02                 pei   TempZero+2
0072 E66B D4 00                 pei   TempZero
0073 E66D A2 02 10 22           _DisposeHandle 
0074 E674 B0 2D                 bcs   error
0075 E676              ;
0076 E676              ;        remove entry in Memory Segment Table
0077 E676              ;
0078 E676 F4 01 00     cont0    pea   SEGTBL>>16               ;address of Memory Segment Table
0079 E679 F4 AA A6              pea   |SEGTBL
0080 E67C D4 0A                 pei   Handle+2                 ;handle of entry
0081 E67E D4 08                 pei   Handle
0082 E680 20 21 F5              jsr   Remove_Link
0083 E683              ;
0084 E683              ;        look for load segment in Load File
0085 E683              ;
0086 E683 A2 00 00     cont1    ldx   #0                       ;output Address
0087 E686 DA                    phx   
0088 E687 DA                    phx   
0089 E688 A3 0B                 lda   IUserID+4,s              ;UserID
0090 E68A 48                    pha   
0091 E68B A3 0B                 lda   IFileNum+6,s             ;Load File Number
0092 E68D 48                    pha   
0093 E68E A3 0B                 lda   ISegNum+8,s              ;Load Segment Number
0094 E690 48                    pha   
0095 E691 DA                    phx                            ;Load Segment Address (0 for allocate)
0096 E692 DA                    phx   
0097 E693 20 B2 E6              jsr   Find_Segment
0098 E696 FA                    plx   
0099 E697 7A                    ply   
0100 E698 B0 09                 bcs   error
0101 E69A 8A                    txa   
0102 E69B              ;
0103 E69B              ;        store address as output and we are done
0104 E69B              ;
0105 E69B 83 09        found    sta   OAddress,s
0106 E69D 98                    tya   
0107 E69E 83 0B                 sta   OAddress+2,s
0108 E6A0 A9 00 00              lda   #0
0109 E6A3 A8 68 83 05  error    Stack_Cleanup 6
0110 E6B1 60                    rts   
0111 E6B2
0112 E6B2                       ENDP 
0113 E6B2
0114 E6B2                       TITLE ', SEGMENTS.a - Find_Segment'
0115 E6B2              *
0116 E6B2              ****************************************************************
0117 E6B2              *
0118 E6B2              *              Find and Load Segment
0119 E6B2              *
0120 E6B2              *  Inputs:     User ID                         (TOS+11)
0121 E6B2              *              Load File Number                (TOS+9)
0122 E6B2              *              Load Segment Number             (TOS+7)
0123 E6B2              *              Load Segment Address            (TOS+3)
0124 E6B2              *  Outputs:    Segment Address                 (TOS+13)
0125 E6B2              *              A - status
0126 E6B2              *              C - set if error occurred
0127 E6B2              *
0128 E6B2              *  Zero Page used: TempZero, CFileNum, CSegNum, CAddress, Counter
0129 E6B2              *
0130 E6B2              *  If Load Segment Number=0, the Jump Table Segment is loaded.
0131 E6B2              *
0132 E6B2              ****************************************************************
0133 E6B2              *
0134 E6B2              Find_Segment PROC 
0135 E6B2                       with DirectPage, Globals
0136 E6B2                       Import save_dp,restore_dp
0137 E6B2
0138 E6B2              OAddress equ   13
0139 E6B2              IUserID  equ   11
0140 E6B2              IFileNum equ   9
0141 E6B2              ISegNum  equ   7
0142 E6B2              IAddress equ   3
0143 E6B2              ;
0144 E6B2              ;        look for entry in Pathname Table for file
0145 E6B2              ;
0146 E6B2 A3 0B                 lda   IUserID,s                ;UserID
0147 E6B4 48                    pha   
0148 E6B5 A3 0B                 lda   IFileNum+2,s             ;File Number
0149 E6B7 48                    pha   
0150 E6B8 A9 00 00              lda   #0                       ;no pathname
0151 E6BB 48                    pha   
0152 E6BC 48                    pha   
0153 E6BD 20 7B F6              jsr   Find_Pathname
0154 E6C0 B0 5F                 bcs   error_skip
0155 E6C2              ;
0156 E6C2              ;       if UserID is an Application, don't close load file
0157 E6C2              ;
0158 E6C2 64 3A                 stz   Keep_Open
0159 E6C4 A3 0B                 lda   IUserID,s
0160 E6C6 29 00 F0              and   #$F000
0161 E6C9 C9 00 10              cmp   #Application
0162 E6CC D0 02                 bne   cont1
0163 E6CE E6 3A                 inc   Keep_Open
0164 E6D0              ;
0165 E6D0              ;        extract Time/Date stamp from entry
0166 E6D0              ;
0167 E6D0 BD 0C 00     cont1    lda   |PT_Date,x
0168 E6D3 85 00                 sta   TempZero
0169 E6D5 BD 0E 00              lda   |PT_Date+2,x
0170 E6D8 85 02                 sta   TempZero+2
0171 E6DA BD 10 00              lda   |PT_Date+4,x
0172 E6DD 85 04                 sta   TempZero+4
0173 E6DF BD 12 00              lda   |PT_Date+6,x
0174 E6E2 85 06                 sta   TempZero+6
0175 E6E4              ;
0176 E6E4              ;        extract pathname of file
0177 E6E4              ;
0178 E6E4 DA           cont     phx                            ;save X
0179 E6E5 20 0D F7              jsr   Get_Pathname
0180 E6E8 FA                    plx                            ;restore x
0181 E6E9 B0 36                 bcs   error_skip
0182 E6EB              ;
0183 E6EB              ;        has Jump Table Segment been processed yet?
0184 E6EB              ;
0185 E6EB BD 18 00     cont2    lda   |PT_Jump,x
0186 E6EE D0 5F                 bne   cont3
0187 E6F0
0188 E6F0 1A                    inc   a                        ;Acc now = 1
0189 E6F1 9D 18 00              sta   |PT_Jump,x               ;set flag
0190 E6F4 4B                    phk                            ;restore DBR
0191 E6F5 AB                    plb                            ;to our bank
0192 E6F6              ;
0193 E6F6              ;        no, load all static segments by calling InitialLoad 2
0194 E6F6              ;
0195 E6F6 20 ED FA              jsr   save_dp                  ;save current direct page
0196 E6F9
0197 E6F9 A3 0F                 lda   IUserID+4,s              ;UserID (+4 because of handle on stack)
0198 E6FB
0199 E6FB                                                      	;make space for output parameters
0200 E6FB 48                    pha                            ;output Direct Page/Stack info
0201 E6FC 48                    pha   
0202 E6FD 48                    pha                            ;output Starting Address
0203 E6FE 48                    pha   
0204 E6FF 48                    pha                            ;output UserID
0205 E700
0206 E700                                                      ;now place the input parameters into direct page
0207 E700 85 E8                 sta   input_parms+8            ;UserID
0208 E702 64 E2                 stz   input_parms+2            ;special memory flag
0209 E704 A5 08                 lda   Handle                   ;Handle of Pathname Table
0210 E706 A4 0A                 ldy   Handle+2
0211 E708 20 D6 FA              jsr   DeRef
0212 E70B 85 E4                 sta   input_parms+4            ;address of Pathname Table entry
0213 E70D 84 E6                 sty   input_parms+6
0214 E70F A9 03 00              lda   #3                       ;input type
0215 E712 85 E0                 sta   input_parms
0216 E714 20 EE B1              jsr   type3_InitLoad           ;private call to InitialLoad
0217 E717
0218 E717 FA                    plx                            ;UserID
0219 E718 FA                    plx                            ;Starting Address
0220 E719 7A                    ply   
0221 E71A FA                    plx                            ;Direct Page/Stack Address
0222 E71B FA                    plx                            ;Direct Page/Stack Size
0223 E71C 20 20 FB              jsr   restore_dp               ;restore our direct page values
0224 E71F 90 03                 bcc   good_load
0225 E721              error_skip  
0226 E721 4C DA E7              jmp   error
0227 E724
0228 E724              good_load  
0229 E724              ;
0230 E724              ;        check whether segment has been loaded (i.e. segment is static)
0231 E724              ;
0232 E724 A9 00 00              lda   #0                       ;output Handle
0233 E727 48                    pha   
0234 E728 48                    pha   
0235 E729 A3 0F                 lda   IUserID+4,s              ;UserID
0236 E72B 48                    pha   
0237 E72C A3 0F                 lda   IFileNum+6,s             ;Load File Number
0238 E72E 48                    pha   
0239 E72F A3 0F                 lda   ISegNum+8,s              ;Load Segment Number
0240 E731 48                    pha   
0241 E732 20 6E F8              jsr   Find_MemSeg
0242 E735 68                    pla                            ;output Handle
0243 E736 68                    pla   
0244 E737 BD 0A 00              lda   |MS_Handle,x             ;handle to segment's memory
0245 E73A BC 0C 00              ldy   |MS_Handle+2,x
0246 E73D              ;
0247 E73D              ;           restore DBR
0248 E73D              ;
0249 E73D 4B                    phk   
0250 E73E AB                    plb   
0251 E73F              ;
0252 E73F              ;        if segment is there, return with address
0253 E73F              ;
0254 E73F B0 0E                 bcs   cont3
0255 E741 20 D6 FA              jsr   DeRef                    ;convert handle to address
0256 E744 83 0D                 sta   OAddress,s
0257 E746 98                    tya   
0258 E747 83 0F                 sta   OAddress+2,s
0259 E749 A9 00 00              lda   #0                       ;no error
0260 E74C 4C DE E7              jmp   return                   ;and exit
0261 E74F              ;
0262 E74F              ;        open file
0263 E74F              ;
0264 E74F 4B           cont3    phk   
0265 E750 AB                    plb   
0266 E751 64 38                 stz   Memory_Load              ;clear Memory Load Flag
0267 E753 D4 1A                 pei   TempBuff+2               ;address of Pathname
0268 E755 D4 18                 pei   TempBuff
0269 E757 D4 06                 pei   TempZero+6               ;time/date stamp
0270 E759 D4 04                 pei   TempZero+4
0271 E75B D4 02                 pei   TempZero+2
0272 E75D D4 00                 pei   TempZero
0273 E75F 20 E4 F1              jsr   Open_File
0274 E762 B0 BD                 bcs   error_skip
0275 E764              ;
0276 E764              ;           skip 'SegNum'-1 number  of Segment Headers and read the next one
0277 E764              ;
0278 E764 A3 07        cont4    lda   ISegNum,s
0279 E766 F0 11                 beq   cont5                    ;if SegNum=0, load Segment 1
0280 E768 3A                    dec   a
0281 E769 F0 0E                 beq   cont5                    ;if SegNum=1, skip skipping
0282 E76B 85 14                 sta   Counter                  ;set counter to Segment Number-1
0283 E76D 20 CA F0     loop     jsr   Skip_Header
0284 E770 A9 01 11              lda   #NoFind
0285 E773 B0 65                 bcs   error
0286 E775 C6 14                 dec   Counter
0287 E777 D0 F4                 bne   loop
0288 E779 20 26 EF     cont5    jsr   Next_Header
0289 E77C B0 5C                 bcs   error
0290 E77E              ;
0291 E77E              ;        load segment - pass 1
0292 E77E              ;
0293 E77E A3 0B                 lda   IUserID,s                ;set global USERID to input UserID
0294 E780 8D B6 A6              sta   |USERID
0295 E783 A3 09                 lda   IFileNum,s               ;set current File Number to FileNum
0296 E785 85 20                 sta   CFileNum
0297 E787 A3 07                 lda   ISegNum,s                ;set current Segment Number to SegNum
0298 E789 85 22                 sta   CSegNum
0299 E78B A3 03                 lda   IAddress,s
0300 E78D 85 24                 sta   CAddress                 ;set current Segment Address to Address
0301 E78F A3 05                 lda   IAddress+2,s
0302 E791 85 26                 sta   CAddress+2
0303 E793 AD AA A6              lda   |SEGTBL
0304 E796 85 34                 sta   FirstMemSeg              ;set first Memory Segment entry
0305 E798 AD AC A6              lda   |SEGTBL+2
0306 E79B 85 36                 sta   FirstMemSeg+2
0307 E79D 64 1C                 stz   Pass                     ;set current pass to 1st pass
0308 E79F 64 1E                 stz   Pass2_Needed             ;zero Pass2 Needed flag
0309 E7A1 A2 01 00              ldx   #1                       ;Special Memory Flag
0310 E7A4              try_again_2  
0311 E7A4 DA                    phx                            ;save special memory flag
0312 E7A5 20 06 E8              jsr   Do_Segment
0313 E7A8 FA                    plx                            ;retrieve special memory flag
0314 E7A9 90 05                 bcc   @no_error                ;no errors, continue
0315 E7AB CA                    dex                            ;should we allow special memory?
0316 E7AC F0 F6                 beq   try_again_2              ;yup, try again
0317 E7AE 80 2A                 bra   error                    ;nope, we've already tried
0318 E7B0              @no_error  
0319 E7B0              ;
0320 E7B0              ;        save address of segment as output
0321 E7B0              ;
0322 E7B0 AD D0 A6              lda   Header.Org
0323 E7B3 83 0D                 sta   OAddress,s
0324 E7B5 AD D2 A6              lda   Header.Org+2
0325 E7B8 83 0F                 sta   OAddress+2,s
0326 E7BA              ;
0327 E7BA              ;        is a second pass needed ?
0328 E7BA              ;
0329 E7BA A5 1E                 lda   Pass2_Needed
0330 E7BC F0 20                 beq   return                   ;no, exit
0331 E7BE E6 1C                 inc   Pass                     ;set current pass to 2nd pass
0332 E7C0              ;
0333 E7C0              ;        yes, position file at Relocation Dictionary
0334 E7C0              ;
0335 E7C0 A9 00 00              lda   #0                       ;output Offset
0336 E7C3 48                    pha   
0337 E7C4 48                    pha   
0338 E7C5 F4 00 00              pea   ML_FirstEntry>>16        ;Offset of 1st entry
0339 E7C8 F4 08 00              pea   |ML_FirstEntry
0340 E7CB 20 0E F1              jsr   Next_Dictionary
0341 E7CE FA                    plx                            ;output Offset
0342 E7CF 7A                    ply   
0343 E7D0 B0 08                 bcs   error
0344 E7D2              ;
0345 E7D2              ;        process Segment's Relocation Dictionary
0346 E7D2              ;
0347 E7D2 A2 00 00              ldx   #0                       ;Special Memory Flag
0348 E7D5 20 06 E8              jsr   Do_Segment
0349 E7D8 90 04                 bcc   return
0350 E7DA
0351 E7DA 64 3A        error    stz   Keep_Open                ;set Keep_Open flag to FALSE
0352 E7DC 4B                    phk                            ;restore DBR
0353 E7DD AB                    plb   
0354 E7DE              return    
0355 E7DE 48           error1   pha                            ;save status
0356 E7DF              ;
0357 E7DF              ;        dispose of temporary pathname buffer
0358 E7DF              ;
0359 E7DF F4 08 70              pea   uTempBuff                ;UserID
0360 E7E2 A2 02 11 22           _DisposeAll 
0361 E7E9              ;
0362 E7E9              ;        dispose of Mark List
0363 E7E9              ;
0364 E7E9 F4 07 70              pea   uMarkList                ;UserID
0365 E7EC A2 02 11 22           _DisposeAll 
0366 E7F3
0367 E7F3 20 0E F3              jsr   Close_File
0368 E7F6
0369 E7F6 68                    pla                            ;restore status
0370 E7F7 A8 68 83 09           Stack_Cleanup 10
0371 E805 60                    rts   
0372 E806
0373 E806                       ENDP 
0374 E806
0375 E806                       TITLE ', SEGMENTS.a - Do_Segment'
0376 E806              *
0377 E806              ****************************************************************
0378 E806              *
0379 E806              *              Process current Segment
0380 E806              *
0381 E806              *  Inputs:     X - Special Memory Flag
0382 E806              *              Header  - Segment Header
0383 E806              *              CFileNum - current File Number
0384 E806              *              CSegNum - current Segment Number
0385 E806              *              CAddress - current Segment Address
0386 E806              *
0387 E806              *  Outputs:    A - status
0388 E806              *              C - set if error occurred
0389 E806              *
0390 E806              *  Zero Page used: TempZero, Handle, FirstMemSeg
0391 E806              *
0392 E806              *        If CAddress is 0, the fields in the Segment Header will
0393 E806              *        determine where a new Memory Segment will be allocated and
0394 E806              *        the Segment will be loaded there.  If CAddress is not
0395 E806              *        0, the Segment will be loaded at that address.
0396 E806              *
0397 E806              ****************************************************************
0398 E806              *
0399 E806              Do_Segment PROC 
0400 E806                       with DirectPage, Globals
0401 E806
0402 E806              ;
0403 E806              ;        which pass are we doing ?
0404 E806              ;
0405 E806 A5 1C                 lda   Pass
0406 E808 F0 2E                 beq   cont1
0407 E80A              ;
0408 E80A              ;        pass 2, look in Memory Segment Table for segment
0409 E80A              ;
0410 E80A A5 34                 lda   FirstMemSeg
0411 E80C 85 08                 sta   Handle
0412 E80E A5 36                 lda   FirstMemSeg+2
0413 E810 85 0A                 sta   Handle+2
0414 E812
0415 E812 A9 00 00              lda   #0                       ;output Handle
0416 E815 48                    pha   
0417 E816 48                    pha   
0418 E817 AD B6 A6              lda   |USERID                  ;UserID
0419 E81A 48                    pha   
0420 E81B D4 20                 pei   CFileNum                 ;Load File Number
0421 E81D D4 22                 pei   CSegNum                  ;Load Segment Number
0422 E81F 20 7A F8              jsr   Next_MemSeg
0423 E822 7A                    ply                            ;output Handle
0424 E823 7A                    ply   
0425 E824 B0 25                 bcs   to_Reloc_Error
0426 E826 BD 0A 00              lda   |MS_Handle,x
0427 E829 BC 0C 00              ldy   |MS_Handle+2,x
0428 E82C 4B                    phk                            ;restore DBR
0429 E82D AB                    plb   
0430 E82E              ;
0431 E82E              ;        set CAddress to Address of current Segment
0432 E82E              ;
0433 E82E 20 D6 FA              jsr   DeRef
0434 E831 85 24                 sta   CAddress
0435 E833 84 26                 sty   CAddress+2
0436 E835              ;
0437 E835              ;        go to record processing loop
0438 E835              ;
0439 E835 4C 07 E9              jmp   Reloc_Loop
0440 E838              ;
0441 E838              ;        pass 1, check whether Version is 1 or 2
0442 E838              ;
0443 E838 AD C7 A6     cont1    lda   Header.Version
0444 E83B 29 FF 00              and   #$FF
0445 E83E C9 01 00              cmp   #1
0446 E841 F0 0B                 beq   cont2
0447 E843 C9 02 00              cmp   #2
0448 E846 F0 06                 beq   cont2
0449 E848              ;
0450 E848              ;        no, the OMF Version is not supported
0451 E848              ;
0452 E848 A9 02 11              lda   #BadOMF
0453 E84B              to_Reloc_Error  
0454 E84B 4C 28 E9              jmp   Reloc_Error
0455 E84E              ;
0456 E84E              ;        check whether SegNum in Header = current Segment Number
0457 E84E              ;
0458 E84E AD DA A6     cont2    lda   Header.SegNum
0459 E851 C5 22                 cmp   CSegNum
0460 E853 F0 06                 beq   cont3
0461 E855              ;
0462 E855              ;        no, this file is corrupt (SegNum out of sequence)
0463 E855              ;
0464 E855 A9 09 11              lda   #BadNum
0465 E858 4C 28 E9              jmp   Reloc_Error
0466 E85B              ;
0467 E85B              ;        check whether Segment is foreign
0468 E85B              ;
0469 E85B A0 0B 11     cont3    ldy   #Foreign
0470 E85E AD D8 A6              lda   Header.NumSex            ;check NumSex
0471 E861 29 FF 00              and   #$FF
0472 E864 F0 04                 beq   cont4                    ;should be 0
0473 E866              ;
0474 E866              ;        yes, Segment is foreign
0475 E866              ;
0476 E866              its_foreign  
0477 E866 98                    tya   
0478 E867 4C 28 E9              jmp   Reloc_Error
0479 E86A
0480 E86A AD C6 A6     cont4    lda   Header.NumLen            ;check NumLen
0481 E86D 29 FF 00              and   #$FF
0482 E870 C9 04 00              cmp   #4                       ;should be 4
0483 E873 D0 F1                 bne   its_foreign
0484 E875              ;
0485 E875              ;        check whether BankSize is legal
0486 E875              ;
0487 E875 AD CA A6     cont5    lda   Header.BankSize+2        ;check BankSize
0488 E878 F0 0A                 beq   cont6                    ;must be <=$10000
0489 E87A C9 01 00              cmp   #1
0490 E87D D0 E7                 bne   its_foreign
0491 E87F AD C8 A6              lda   Header.BankSize
0492 E882 D0 E2                 bne   its_foreign
0493 E884              ;
0494 E884              ;        check whether Align is legal
0495 E884              ;
0496 E884 AD D6 A6     cont6    lda   Header.Align+2           ;check Align
0497 E887 F0 0A                 beq   cont7                    ;must be <=$10000
0498 E889 C9 01 00              cmp   #1
0499 E88C D0 D8                 bne   its_foreign
0500 E88E AD D4 A6              lda   Header.Align
0501 E891 D0 D3                 bne   its_foreign
0502 E893              ;
0503 E893              ;        check whether there is any data in the segment
0504 E893              ;
0505 E893 AD B8 A6     cont7    lda   Header.ByteCnt           ;if BYTECNT=0, no data
0506 E896 0D BA A6              ora   Header.ByteCnt+2
0507 E899 D0 03                 bne   cont7a
0508 E89B              to_Reloc_Return  
0509 E89B 4C 28 E9              jmp   Reloc_Return             ;no data
0510 E89E
0511 E89E AD C0 A6     cont7a   lda   Header.Length            ;if LENGTH=0, no data
0512 E8A1 0D C2 A6              ora   Header.Length+2
0513 E8A4 F0 F5                 beq   to_Reloc_Return          ;no data
0514 E8A6              ;
0515 E8A6              ;        if CAddress<>0, segment will be loaded into existing memory buffer
0516 E8A6              ;
0517 E8A6 A5 24        cont8    lda   CAddress
0518 E8A8 05 26                 ora   CAddress+2
0519 E8AA F0 28                 beq   cont9
0520 E8AC              ;
0521 E8AC              ;        find Memory Handle that corresponds to CAddress
0522 E8AC              ;
0523 E8AC DA                    phx                            ;save X (Special Memory Flag)
0524 E8AD A9 00 00              lda   #0                       ;output Handle
0525 E8B0 48                    pha   
0526 E8B1 48                    pha   
0527 E8B2 A5 26                 lda   CAddress+2               ;Address (bank)
0528 E8B4 8D D2 A6              sta   Header.Org+2
0529 E8B7 48                    pha   
0530 E8B8 A5 24                 lda   CAddress
0531 E8BA 8D D0 A6              sta   Header.Org
0532 E8BD 48                    pha   
0533 E8BE A2 02 1A 22           _FindHandle 
0534 E8C5 68                    pla                            ;output Handle
0535 E8C6 7A                    ply   
0536 E8C7 85 08                 sta   Handle
0537 E8C9 84 0A                 sty   Handle+2
0538 E8CB              ;
0539 E8CB              ;        zero memory segment
0540 E8CB              ;
0541 E8CB 20 D6 FA              jsr   DeRef                    ;dereference Handle
0542 E8CE 20 A5 EB              jsr   Zero_Segment
0543 E8D1
0544 E8D1 FA                    plx                            ;restore X
0545 E8D2 80 33                 bra   Reloc_Loop
0546 E8D4              ;
0547 E8D4              ;        get memory segment for load segment
0548 E8D4              ;
0549 E8D4 8A           cont9    txa                            ;Special Memory Flag
0550 E8D5 20 6D EA              jsr   Allocate_Segment
0551 E8D8 B0 4E                 bcs   Reloc_Error
0552 E8DA
0553 E8DA AD D0 A6              lda   Header.Org
0554 E8DD 85 24                 sta   CAddress                 ;save Load Address
0555 E8DF AD D2 A6              lda   Header.Org+2
0556 E8E2 85 26                 sta   CAddress+2
0557 E8E4              ;
0558 E8E4              ;        create new entry in Memory Segment Table
0559 E8E4              ;
0560 E8E4 D4 0A                 pei   Handle+2                 ;Memory Handle
0561 E8E6 D4 08                 pei   Handle
0562 E8E8 AD B6 A6              lda   |USERID
0563 E8EB 48                    pha   
0564 E8EC D4 20                 pei   CFileNum                 ;Load File Number
0565 E8EE D4 22                 pei   CSegNum                  ;Load Segment Number
0566 E8F0 AD CC A6              lda   Header.Kind              ;Load Segment Kind
0567 E8F3 48                    pha   
0568 E8F4 20 FD F7              jsr   Add_MemSeg
0569 E8F7 B0 2F                 bcs   Reloc_Error
0570 E8F9              ;
0571 E8F9              ;        if this is first segment loaded, save Memory Segment Table handle
0572 E8F9              ;
0573 E8F9 A5 34                 lda   FirstMemSeg
0574 E8FB 05 36                 ora   FirstMemSeg+2
0575 E8FD D0 08                 bne   Reloc_Loop
0576 E8FF A5 00                 lda   TempZero
0577 E901 85 34                 sta   FirstMemSeg
0578 E903 A5 02                 lda   TempZero+2
0579 E905 85 36                 sta   FirstMemSeg+2
0580 E907              ;
0581 E907              ;        process each Segment record until the END record is reached
0582 E907              ;
0583 E907                       ENTRY Reloc_Loop
0584 E907              Reloc_Loop  
0585 E907 20 8C F0              jsr   Read_Op                  ;read operation code
0586 E90A B0 1C                 bcs   Reloc_Error
0587 E90C
0588 E90C AD 04 A7              lda   |Record                  ;get record operation code
0589 E90F 29 FF 00              and   #$FF
0590 E912 F0 14                 beq   Reloc_Return             ;END record found, we are done
0591 E914              ;
0592 E914              ;        search Record Table for OP code
0593 E914              ;
0594 E914 A2 18 00              ldx   #6*4                     ;7 double entries in table
0595 E917 DD 2E E9     loop2    cmp   Record_Table,x
0596 E91A D0 03                 bne   cont10
0597 E91C              ;
0598 E91C              ;        found OP code in Table, put OP code routine address on stack and
0599 E91C              ;        jump to it
0600 E91C              ;
0601 E91C 7C 30 E9              jmp   (Record_Table+2,x)
0602 E91F
0603 E91F CA           cont10   dex   
0604 E920 CA                    dex   
0605 E921 CA                    dex   
0606 E922 CA                    dex   
0607 E923 10 F2                 bpl   loop2
0608 E925              ;
0609 E925              ;        OP code not in table, error
0610 E925              ;
0611 E925 A9 0A 11              lda   #Illegal                 ;illegal record operation code
0612 E928
0613 E928                       ENTRY Reloc_Return,Reloc_Error
0614 E928              Reloc_Return  
0615 E928              Reloc_Error  
0616 E928 4B                    phk                            ;restore DBR just in case
0617 E929 AB                    plb   
0618 E92A C9 01 00              cmp   #1
0619 E92D 60                    rts   
0620 E92E
0621 E92E              Record_Table  
0622 E92E F1 00 5A EC           DC W:DS,Do_DS
0623 E932 F2 00 02 EC           DC W:LCONST,Do_LCONST
0624 E936 E3 00 B5 EC           DC W:INTERSEG,Do_INTERSEG
0625 E93A E2 00 67 EC           DC W:RELOC,Do_RELOC
0626 E93E F6 00 DF EC           DC W:cINTERSEG,Do_cINTERSEG
0627 E942 F5 00 8E EC           DC W:cRELOC,Do_cRELOC
0628 E946 F7 00 3D ED           DC W:SUPER,Do_SUPER
0629 E94A
0630 E94A                       ENDP 
0631 E94A
0632 E94A                       TITLE ', SEGMENTS.a - Do_Init_Segment'
0633 E94A              *
0634 E94A              ****************************************************************
0635 E94A              *
0636 E94A              *              Process Initialization Segment
0637 E94A              *
0638 E94A              * Inputs: A,Y - Address of Segment
0639 E94A              *
0640 E94A              * Direct Page used - TempZero
0641 E94A              ****************************************************************
0642 E94A              *
0643 E94A              Do_Init_Segment PROC 
0644 E94A
0645 E94A 3A                    dec   a                        ;Address -1
0646 E94B 8B                    phb                            ;yes, save Data Bank register
0647 E94C 0B                    phd                            ;save Direct register
0648 E94D 4B                    phk                            ;setup stack for implicit JSL
0649 E94E F4 5B E9              pea   cont-1
0650 E951
0651 E951 E2 10                 sep   #$10                     ;8-bit index registers
0652 E953 5A                    phy                            ;put high byte of address on stack
0653 E954 C2 10                 rep   #$10
0654 E956 48                    pha                            ;put segment address on stack
0655 E957 A9 00 00              lda   #0                       ;set Direct register to 0
0656 E95A 5B                    tcd   
0657 E95B 6B                    rtl                            ;do implicit JSL
0658 E95C
0659 E95C 2B           cont     pld                            ;restore Direct register
0660 E95D AB                    plb                            ;restore Data Bank register
0661 E95E C2 30                 rep   #$30                     ;restore 16 bit mode
0662 E960 60                    rts   
0663 E961
0664 E961                       ENDP 
0665 E961
0666 E961                       TITLE ', SEGMENTS.a - Do_Path_Segment'
0667 E961              *
0668 E961              ****************************************************************
0669 E961              *
0670 E961              *        Process Pathname Segment
0671 E961              *
0672 E961              *  Inputs: Handle  of segment in memory (TOS+7)
0673 E961              *          Address of segment in memory (TOS+3)
0674 E961              *
0675 E961              *  Zero Page used: Pointer,TempBuff
0676 E961              *
0677 E961              ****************************************************************
0678 E961              *
0679 E961
0680 E961              Do_Path_Segment PROC 
0681 E961                       with DirectPage, Globals
0682 E961              ;
0683 E961              ;        inputs on stack
0684 E961              ;
0685 E961              SHandle  equ   7
0686 E961              SAddress equ   3
0687 E961              ;
0688 E961              ;        fields in Pathname Segment entry
0689 E961              ;
0690 E961              File_Num equ   0
0691 E961              File_Date equ   2
0692 E961              File_Path equ   10
0693 E961
0694 E961 A3 03                 lda   SAddress,s
0695 E963 85 10                 sta   Pointer
0696 E965 A3 05                 lda   SAddress+2,s
0697 E967 85 12                 sta   Pointer+2
0698 E969 A0 00 00     loop     ldy   #File_Num                ;get next File Number
0699 E96C B7 10                 lda   [Pointer],y
0700 E96E F0 6C                 beq   return                   ;if 0, we are done
0701 E970 AD B6 A6              lda   |USERID                  ;UserID
0702 E973 48                    pha   
0703 E974 A0 00 00              ldy   #File_Num
0704 E977 B7 10                 lda   [Pointer],y              ;File Number
0705 E979 48                    pha   
0706 E97A A0 08 00              ldy   #File_Date+6             ;File Date
0707 E97D B7 10                 lda   [Pointer],y
0708 E97F 48                    pha   
0709 E980 A0 06 00              ldy   #File_Date+4
0710 E983 B7 10                 lda   [Pointer],y
0711 E985 48                    pha   
0712 E986 A0 04 00              ldy   #File_Date+2             ;File Date
0713 E989 B7 10                 lda   [Pointer],y
0714 E98B 48                    pha   
0715 E98C A0 02 00              ldy   #File_Date
0716 E98F B7 10                 lda   [Pointer],y
0717 E991 48                    pha   
0718 E992 A2 00 00              ldx   #0                       ;Direct Page/Stack info
0719 E995 DA                    phx   
0720 E996 DA                    phx   
0721 E997 DA                    phx                            ;Starting Address
0722 E998 DA                    phx   
0723 E999 A4 12                 ldy   Pointer+2                ;calculate address of pathname
0724 E99B A5 10                 lda   Pointer
0725 E99D 18                    clc   
0726 E99E 69 0A 00              adc   #File_Path
0727 E9A1 90 01                 bcc   @1
0728 E9A3 C8                    iny   
0729 E9A4              @1                                      ;A,Y - pathname
0730 E9A4                                                      ;   ldx     #0 (already)        ;X - convert 0 pathname to 1
0731 E9A4 20 4E F7              jsr   Convert_Pathname         ;convert Pathname
0732 E9A7 A5 18                 lda   TempBuff                 ;converted Pathname
0733 E9A9 A4 1A                 ldy   TempBuff+2
0734 E9AB 20 96 F7              jsr   Expand_Pathname          ;expand Pathname
0735 E9AE D4 1A                 pei   TempBuff+2               ;expanded Pathname
0736 E9B0 D4 18                 pei   TempBuff
0737 E9B2 20 B4 F5              jsr   Add_Pathname             ;add entry to Pathname Table
0738 E9B5 B0 25                 bcs   return
0739 E9B7              ;
0740 E9B7              ;        bump SAddress and Pointer to next entry
0741 E9B7              ;
0742 E9B7 A3 03                 lda   SAddress,s
0743 E9B9 85 10                 sta   Pointer
0744 E9BB A3 05                 lda   SAddress+2,s
0745 E9BD 85 12                 sta   Pointer+2
0746 E9BF A0 0A 00              ldy   #File_Path
0747 E9C2 B7 10                 lda   [Pointer],y
0748 E9C4 29 FF 00              and   #$FF
0749 E9C7 18                    clc   
0750 E9C8 69 0B 00              adc   #11
0751 E9CB 65 10                 adc   Pointer
0752 E9CD 85 10                 sta   Pointer
0753 E9CF 83 03                 sta   SAddress,s
0754 E9D1 A5 12                 lda   Pointer+2
0755 E9D3 69 00 00              adc   #0
0756 E9D6 85 12                 sta   Pointer+2
0757 E9D8 83 05                 sta   SAddress+2,s
0758 E9DA 80 8D                 bra   loop
0759 E9DC              ;
0760 E9DC              ;        return
0761 E9DC              ;
0762 E9DC A8 68 83 07  return   Stack_Cleanup 8                ;remove input parameters
0763 E9EA 60                    rts   
0764 E9EB                       ENDP 
0765 E9EB
0766 E9EB                       TITLE ', SEGMENTS.a - Do_Jump_Segment'
0767 E9EB              *
0768 E9EB              ****************************************************************
0769 E9EB              *
0770 E9EB              *        Process Jump Table Segment
0771 E9EB              *
0772 E9EB              *  Inputs: Handle  of segment in memory (TOS+7)
0773 E9EB              *          Address of segment in memory (TOS+3)
0774 E9EB              *
0775 E9EB              *  Zero Page used: TempZero
0776 E9EB              *
0777 E9EB              ****************************************************************
0778 E9EB              *
0779 E9EB
0780 E9EB              Do_Jump_Segment PROC 
0781 E9EB                       with DirectPage, Globals
0782 E9EB              ;
0783 E9EB              ;        inputs on stack
0784 E9EB              ;
0785 E9EB              SHandle  equ   7
0786 E9EB              SAddress equ   3
0787 E9EB
0788 E9EB              ;
0789 E9EB              ; copy address to ExpressLoad variables, and then call the ExpressLoad function
0790 E9EB              ;
0791 E9EB A3 03                 lda   SAddress,s
0792 E9ED 85 4A                 sta   base_ptr
0793 E9EF A3 05                 lda   SAddress+2,s
0794 E9F1 85 4C                 sta   base_ptr+2
0795 E9F3 20 C4 E2              jsr   patch_jmp_tbl
0796 E9F6              ;
0797 E9F6              ;        allocate memory buffer for new Jump Table List entry
0798 E9F6              ;
0799 E9F6 A9 00 00     cont2    lda   #0                       ;output Handle
0800 E9F9 48                    pha   
0801 E9FA 48                    pha   
0802 E9FB F4 00 00              pea   JT_Handle+4>>16          ;BlockSize
0803 E9FE F4 0E 00              pea   |JT_Handle+4
0804 EA01 F4 05 70              pea   uJMPTBL                  ;Owner
0805 EA04 F4 08 80              pea   attrLocked+attrNoSpec    ;Attributes
0806 EA07 48                    pha                            ;Location
0807 EA08 48                    pha   
0808 EA09 A2 02 09 22           _NewHandle                     ;get memory buffer
0809 EA10 FA                    plx   
0810 EA11 7A                    ply   
0811 EA12 86 00                 stx   TempZero                 ;save returned handle
0812 EA14 84 02                 sty   TempZero+2
0813 EA16 B0 46                 bcs   error
0814 EA18
0815 EA18 8A                    txa   
0816 EA19 20 D6 FA              jsr   DeRef                    ;dereference handle
0817 EA1C 85 04                 sta   TempZero+4               ;save pointer
0818 EA1E 84 06                 sty   TempZero+6
0819 EA20              ;
0820 EA20              ;        zero linked list pointers
0821 EA20              ;
0822 EA20 A9 00 00              lda   #0
0823 EA23 A0 06 00              ldy   #6
0824 EA26              @loop     
0825 EA26 97 04                 sta   [TempZero+4],y
0826 EA28 88                    dey   
0827 EA29 88                    dey   
0828 EA2A 10 FA                 bpl   @loop
0829 EA2C              ;
0830 EA2C              ;        make pointer usable
0831 EA2C              ;
0832 EA2C A5 04                 lda   TempZero+4
0833 EA2E A4 06                 ldy   TempZero+6
0834 EA30 8B                    phb                            ;save DBR
0835 EA31 20 CF FA              jsr   UsePtr
0836 EA34              ;
0837 EA34              ;        store data in Jump Table List entry
0838 EA34              ;
0839 EA34 AF B6 A6 01           lda   >USERID                  ;UserID
0840 EA38 9D 08 00              sta   |JT_UserID,x
0841 EA3B A3 08                 lda   SHandle+1,s              ;Handle to Jump Table Segment
0842 EA3D 9D 0A 00              sta   |JT_Handle,x
0843 EA40 A3 0A                 lda   SHandle+3,s
0844 EA42 9D 0C 00              sta   |JT_Handle+2,x
0845 EA45 AB                    plb                            ;restore DBR
0846 EA46              ;
0847 EA46              ;        link new entry to previous
0848 EA46              ;
0849 EA46 F4 01 00              pea   JMPTBL>>16
0850 EA49 F4 AE A6              pea   |JMPTBL
0851 EA4C D4 02                 pei   TempZero+2
0852 EA4E D4 00                 pei   TempZero
0853 EA50 20 A8 F4              jsr   Add_Link
0854 EA53              ;
0855 EA53              ;        unlock Jump Table List entry
0856 EA53              ;
0857 EA53 D4 02                 pei   TempZero+2
0858 EA55 D4 00                 pei   TempZero
0859 EA57 A2 02 22 22           _HUnlock 
0860 EA5E A8 68 83 07  error    Stack_Cleanup 8                ;remove input parameters
0861 EA6C 60                    rts   
0862 EA6D
0863 EA6D                       ENDP 
0864 EA6D
0865 EA6D                       TITLE ', SEGMENTS.a - Allocate_Segment'
0866 EA6D              *
0867 EA6D              ****************************************************************
0868 EA6D              *
0869 EA6D              *        Allocate a Memory Segment for a Segment
0870 EA6D              *
0871 EA6D              *  Inputs:     A - Special Memory Flag
0872 EA6D              *              Header - Segment Header
0873 EA6D              *
0874 EA6D              *  Outputs:    Handle - Handle to Memory Segment
0875 EA6D              *              Header+ORG - Address of Memory Segment
0876 EA6D              *              A - status code
0877 EA6D              *              C - set if error
0878 EA6D              *
0879 EA6D              *  Zero Page used: TempZero, Counter, Handle
0880 EA6D              *
0881 EA6D              ****************************************************************
0882 EA6D              *
0883 EA6D
0884 EA6D              Allocate_Segment PROC  
0885 EA6D                       with DirectPage, Globals
0886 EA6D
0887 EA6D 85 B2                 sta   spec_mem_flag            ;save for use by conv_attributes
0888 EA6F A9 B4 A6              lda   #<(Header-4)             ;set up seg_header_ptr
0889 EA72 85 4E                 sta   seg_header_ptr
0890 EA74 A9 01 00              lda   #^(Header-4)             ;to make ExpressLoad subroutine happy
0891 EA77 85 50                 sta   seg_header_ptr+2
0892 EA79 20 8F DE              jsr   conv_attributes          ;calculate memory attributes required
0893 EA7C 48                    pha                            ;save on stack
0894 EA7D 85 14                 sta   Counter                  ;save (TempZero is used later)
0895 EA7F
0896 EA7F AD CC A6              lda   Header.Kind              ;get the segment kind
0897 EA82 89 00 08              bit   #AbsBank_Segment         ;Absolute Bank Segment?
0898 EA85 D0 0D                 bne   @skip_special            ;yes, don't set the NoSpecialMemory attribute
0899 EA87 29 1F 00              and   #$001f                   ;mask out the attributes
0900 EA8A C9 12 00              cmp   #Direct_Segment          ;direct page?
0901 EA8D F0 05                 beq   @skip_special            ;yes, don't set the NoSpecialMemory attribute
0902 EA8F A9 08 00              lda   #attrNoSpec              ;set the NoSpecialMemory bit
0903 EA92 04 14                 tsb   Counter
0904 EA94              @skip_special  
0905 EA94 20 CA EA              jsr   allocate_mem             ;go allocate the memory
0906 EA97 90 22                 bcc   cont                     ;if no error, we are done
0907 EA99              ;
0908 EA99              ;        couldn't allocate memory but maybe the Loader is wasting memory sooo
0909 EA99              ;        call Cleanup routine to attempt to free more memory.
0910 EA99              ;
0911 EA99 48                    pha                            ;save Memory Manager error
0912 EA9A F4 00 00              pea   0                        ;all UserID's
0913 EA9D 20 A0 F9              jsr   Cleanup                  ;cleanup internal tables
0914 EAA0 68                    pla                            ;restore Memory Manager error
0915 EAA1 B0 25                 bcs   error
0916 EAA3
0917 EAA3 20 CA EA              jsr   allocate_mem             ;go allocate the memory
0918 EAA6 90 13                 bcc   cont                     ;got it!
0919 EAA8 AA                    tax                            ;save error code
0920 EAA9 A3 01                 lda   1,s                      ;retrieve original attributes
0921 EAAB 89 08 00              bit   #attrNoSpec              ;was the noSpecialMemory attribute set already?
0922 EAAE F0 04                 beq   @try_again               ;no, so try again, allowing special memory
0923 EAB0 8A                    txa                            ;restore error code to accumulator
0924 EAB1 38                    sec   
0925 EAB2 80 14                 bra   error                    ;and we're outta here
0926 EAB4              @try_again  
0927 EAB4 85 14                 sta   Counter                  ;use the original attributes this time
0928 EAB6 20 CA EA              jsr   allocate_mem             ;try this one last time
0929 EAB9 B0 0D                 bcs   error                    ;OK already, I give up!
0930 EABB              ;
0931 EABB              ;        dereference the memory segment Handle
0932 EABB              ;
0933 EABB              cont      
0934 EABB 8A                    txa                            ;get handle into Acc and Y
0935 EABC 20 D6 FA              jsr   DeRef                    ;dereference Handle
0936 EABF 8D D0 A6              sta   Header.Org               ;save in Segment Header
0937 EAC2 8C D2 A6              sty   Header.Org+2
0938 EAC5              ;
0939 EAC5              ;        zero out segment to speed up DS record processing
0940 EAC5              ;
0941 EAC5 20 A5 EB              jsr   Zero_Segment
0942 EAC8              ;
0943 EAC8              ;        normal return
0944 EAC8              ;
0945 EAC8              error     
0946 EAC8 FA                    plx                            ;clean up stack (remove original attributes)
0947 EAC9 60                    rts   
0948 EACA
0949 EACA              allocate_mem  
0950 EACA A5 14                 lda   Counter                  ;copy attributes
0951 EACC 85 D8                 sta   mem_attr
0952 EACE AD D0 A6              lda   Header.Org
0953 EAD1 85 C0                 sta   org_address
0954 EAD3 AD D2 A6              lda   Header.Org+2
0955 EAD6 85 C2                 sta   org_address+2
0956 EAD8 AE C0 A6              ldx   Header.Length
0957 EADB AC C2 A6              ldy   Header.Length+2
0958 EADE 20 9A D0              jsr   alloc_LConst_seg
0959 EAE1 86 08                 stx   Handle                   ;Handle
0960 EAE3 84 0A                 sty   Handle+2
0961 EAE5 60                    rts   
0962 EAE6
0963 EAE6                       ENDP 
0964 EAE6
0965 EAE6                       TITLE ', SEGMENTS.a - Purge_Segment'
0966 EAE6              *
0967 EAE6              ****************************************************************
0968 EAE6              *
0969 EAE6              *        Purge Segment
0970 EAE6              *
0971 EAE6              *  Inputs:     User ID                       (TOS+11)
0972 EAE6              *              Load File Number              (TOS+9)
0973 EAE6              *              Load Segment Number           (TOS+7)
0974 EAE6              *              Dynamic Only Flag             (TOS+5)
0975 EAE6              *              Purge Level                   (TOS+3)
0976 EAE6              *
0977 EAE6              *  Outputs:    A - status code
0978 EAE6              *              C - set if entry not found or error ocurred
0979 EAE6              *
0980 EAE6              *  Zero Page used: TempZero, Handle
0981 EAE6              *
0982 EAE6              *        The Memory Segment Table is searched for the specified
0983 EAE6              *        Load Segment or all segments (if UserID=0).  The Memory Block
0984 EAE6              *        for the segment is either made purgeable (if Purge Level>0) or
0985 EAE6              *        disposed (if Purge Level=0) and all the Jump Table entries for
0986 EAE6              *        the segment are marked as unloaded.
0987 EAE6              *
0988 EAE6              *        If the UserID is 0, only segments which are no longer in memory
0989 EAE6              *        (their Memory Segment Handle is NIL) are processed.
0990 EAE6              *
0991 EAE6              *        If a Memory Segment Handle is disposed, the Handle in the Memory
0992 EAE6              *        Segment Table entry is set to 0.
0993 EAE6              *
0994 EAE6              *        If the Dynamic Only Flag is set, only Dynamic Load Segments
0995 EAE6              *        are processed.
0996 EAE6              *
0997 EAE6              *        If any of the 1st three inputs are 0, all entries in the
0998 EAE6              *        Memory Segment Table are searched and only the entries
0999 EAE6              *        with attributes equal to the non-zero inputs are processed.
1000 EAE6              *
1001 EAE6              ****************************************************************
1002 EAE6              *
1003 EAE6
1004 EAE6              Purge_Segment PROC 
1005 EAE6                       with DirectPage, Globals
1006 EAE6
1007 EAE6              IUserID  equ   11
1008 EAE6              FileNum  equ   9
1009 EAE6              SegNum   equ   7
1010 EAE6              Dynamic  equ   5
1011 EAE6              PLevel   equ   3
1012 EAE6              ;
1013 EAE6              ;        if any of the inputs are 0, set Pass2_Needed
1014 EAE6              ;
1015 EAE6 A2 01 00              ldx   #1
1016 EAE9 A3 0B                 lda   IUserID,s
1017 EAEB F0 09                 beq   cont1
1018 EAED A3 09                 lda   FileNum,s
1019 EAEF F0 05                 beq   cont1
1020 EAF1 A3 07                 lda   SegNum,s
1021 EAF3 F0 01                 beq   cont1
1022 EAF5 CA                    dex   
1023 EAF6              ;
1024 EAF6              ;        search Memory Segment Table for entry corresponding to inputs
1025 EAF6              ;
1026 EAF6 86 1E        cont1    stx   Pass2_Needed
1027 EAF8 AD AA A6              lda   |SEGTBL
1028 EAFB 85 08                 sta   Handle
1029 EAFD AD AC A6              lda   |SEGTBL+2
1030 EB00 85 0A                 sta   Handle+2
1031 EB02 A9 00 00     loop     lda   #0                       ;output Handle
1032 EB05 48                    pha   
1033 EB06 48                    pha   
1034 EB07 A3 0F                 lda   IUserID+4,s              ;UserID
1035 EB09 48                    pha   
1036 EB0A A3 0F                 lda   FileNum+6,s              ;File Number
1037 EB0C 48                    pha   
1038 EB0D A3 0F                 lda   SegNum+8,s               ;Segment Number
1039 EB0F 48                    pha   
1040 EB10 20 7A F8              jsr   Next_MemSeg
1041 EB13 68                    pla   
1042 EB14 85 00                 sta   TempZero                 ;output Handle
1043 EB16 68                    pla   
1044 EB17 85 02                 sta   TempZero+2
1045 EB19 BD 0A 00              lda   |MS_Handle,x
1046 EB1C 85 04                 sta   TempZero+4               ;save Handle of Memory block
1047 EB1E BD 0C 00              lda   |MS_Handle+2,x
1048 EB21 85 06                 sta   TempZero+6
1049 EB23 A9 01 11              lda   #NoFind
1050 EB26 B0 65                 bcs   error
1051 EB28              ;
1052 EB28              ;        if Dynamic Only Flag is set, skip if not a Dynamic Load Segment
1053 EB28              ;
1054 EB28 A3 05                 lda   Dynamic,s
1055 EB2A F0 08                 beq   cont2
1056 EB2C BD 12 00              lda   |MS_Kind,x
1057 EB2F 89 00 80              bit   #Dyn_Segment
1058 EB32 F0 52                 beq   eloop
1059 EB34              ;
1060 EB34              ;        check Purge Level
1061 EB34              ;
1062 EB34 A3 03        cont2    lda   PLevel,s
1063 EB36 D0 22                 bne   cont3
1064 EB38              ;
1065 EB38              ;        Purge Level=0, dispose of Memory Block if
1066 EB38              ;
1067 EB38              ;            a) UserID<>0
1068 EB38              ;        or
1069 EB38              ;            b) UserID=0 and Handle=NIL
1070 EB38              ;
1071 EB38 A3 0B                 lda   IUserID,s
1072 EB3A D0 09                 bne   cont2a
1073 EB3C A5 04                 lda   TempZero+4               ;Memory Segment Handle
1074 EB3E A4 06                 ldy   TempZero+6
1075 EB40 20 D6 FA              jsr   DeRef                    ;deference
1076 EB43 90 41                 bcc   eloop                    ;if not NIL, skip this entry
1077 EB45 DA           cont2a   phx                            ;save X
1078 EB46 D4 06                 pei   TempZero+6
1079 EB48 D4 04                 pei   TempZero+4
1080 EB4A A2 02 10 22           _DisposeHandle                 ;error is OK
1081 EB51 FA                    plx                            ;restore X
1082 EB52              ;
1083 EB52              ;        set Handle in entry to 0
1084 EB52              ;
1085 EB52 9E 0A 00              stz   |MS_Handle,x
1086 EB55 9E 0C 00              stz   |MS_Handle+2,x
1087 EB58 80 1B                 bra   cont4
1088 EB5A              ;
1089 EB5A              ;        Purge Level>0, unlock Memory Block and set its Purge Level
1090 EB5A              ;
1091 EB5A DA           cont3    phx                            ;save X
1092 EB5B D4 06                 pei   TempZero+6
1093 EB5D D4 04                 pei   TempZero+4
1094 EB5F A2 02 22 22           _HUnlock                       ;error is OK
1095 EB66
1096 EB66 A3 05                 lda   PLevel+2,s
1097 EB68 48                    pha   
1098 EB69 D4 06                 pei   TempZero+6
1099 EB6B D4 04                 pei   TempZero+4
1100 EB6D A2 02 24 22           _SetPurge                      ;error is OK
1101 EB74 FA                    plx                            ;restore X
1102 EB75              ;
1103 EB75              ;        unload all entries in Jump Table for this segment
1104 EB75              ;
1105 EB75 BD 08 00     cont4    lda   |MS_UserID,x             ;UserID
1106 EB78 48                    pha   
1107 EB79 BD 0E 00              lda   |MS_FileNum,x            ;Load File Number
1108 EB7C 48                    pha   
1109 EB7D BD 10 00              lda   |MS_SegNum,x             ;Load Segment Number
1110 EB80 48                    pha   
1111 EB81 4B                    phk                            ;restore DBR
1112 EB82 AB                    plb   
1113 EB83 20 19 F9              jsr   Unload_JTL
1114 EB86              ;
1115 EB86              ;        if any inputs = 0, keep looking for segments to unload
1116 EB86              ;
1117 EB86 A5 1E        eloop    lda   Pass2_Needed
1118 EB88 F0 03                 beq   return
1119 EB8A 4C 02 EB              jmp   loop
1120 EB8D              ;
1121 EB8D              ;        normal return
1122 EB8D              ;
1123 EB8D              return    
1124 EB8D 4B           error    phk                            ;restore DBR
1125 EB8E AB                    plb   
1126 EB8F              ;
1127 EB8F              ;        if any inputs = 0, error is not really an error
1128 EB8F              ;
1129 EB8F A6 1E                 ldx   Pass2_Needed
1130 EB91 F0 03                 beq   cont5
1131 EB93 A9 00 00              lda   #0
1132 EB96 A8 68 83 09  cont5    Stack_Cleanup 10               ;remove input parameters
1133 EBA4 60                    rts   
1134 EBA5
1135 EBA5                       ENDP 
1136 EBA5
1137 EBA5                       TITLE ', SEGMENTS.a - Zero_Segment'
1138 EBA5              *
1139 EBA5              ****************************************************************
1140 EBA5              *
1141 EBA5              *        Zero Segment
1142 EBA5              *
1143 EBA5              *  Inputs:     A,Y - Address of Segment in Memory
1144 EBA5              *              Header - Segment Header
1145 EBA5              *
1146 EBA5              *  Outputs:    none
1147 EBA5              *
1148 EBA5              *  Zero Page used: TempZero
1149 EBA5              *
1150 EBA5              ****************************************************************
1151 EBA5              *
1152 EBA5
1153 EBA5              Zero_Segment PROC 
1154 EBA5                       with DirectPage, Globals
1155 EBA5
1156 EBA5 85 00                 sta   TempZero                 ;address of Segment in memory
1157 EBA7 84 02                 sty   TempZero+2
1158 EBA9 5A                    phy                            ;Source
1159 EBAA 48                    pha   
1160 EBAB A9 00 00              lda   #0
1161 EBAE 87 00                 sta   [TempZero]               ;zero 1st 2 bytes
1162 EBB0 A5 00                 lda   TempZero                 ;offset past first two bytes
1163 EBB2 18                    clc   
1164 EBB3 69 02 00              adc   #2
1165 EBB6 90 01                 bcc   @1
1166 EBB8 C8                    iny   
1167 EBB9              @1        
1168 EBB9 5A                    phy                            ;Destination
1169 EBBA 48                    pha   
1170 EBBB AC C2 A6              ldy   Header.Length+2
1171 EBBE AD C0 A6              lda   Header.Length
1172 EBC1 38                    sec   
1173 EBC2 E9 02 00              sbc   #2
1174 EBC5 B0 01                 bcs   @2
1175 EBC7 88                    dey   
1176 EBC8              @2        
1177 EBC8 5A                    phy                            ;Count
1178 EBC9 48                    pha   
1179 EBCA
1180 EBCA 20 EE F9              jsr   Block_Move
1181 EBCD 60                    rts   
1182 EBCE
1183 EBCE                       ENDP 
1184 EBCE
1185 EBCE                       TITLE ', SEGMENTS.a - Check_KIND'
1186 EBCE              *
1187 EBCE              ****************************************************************
1188 EBCE              *
1189 EBCE              *              Check KIND field
1190 EBCE              *
1191 EBCE              *  Inputs:     Header - Segment Header
1192 EBCE              *
1193 EBCE              *  Outputs:    Header - Segment Header
1194 EBCE              *
1195 EBCE              *  Zero Page used: TempZero
1196 EBCE              *
1197 EBCE              *        This routine checks whether the old KIND field is used in
1198 EBCE              *        Segment Header and converts it to the new KIND field.
1199 EBCE              *
1200 EBCE              ****************************************************************
1201 EBCE              *
1202 EBCE
1203 EBCE              Check_KIND PROC 
1204 EBCE                       with DirectPage, Globals
1205 EBCE              ;
1206 EBCE              ;        if Version>1, no conversion needed
1207 EBCE              ;
1208 EBCE AD C7 A6              lda   Header.Version
1209 EBD1 C9 02 00              cmp   #2
1210 EBD4 B0 2B                 bcs   return
1211 EBD6              ;
1212 EBD6              ;        move Type to KIND field
1213 EBD6              ;
1214 EBD6 AD C4 A6              lda   Header.oldKind
1215 EBD9 48                    pha   
1216 EBDA 29 1F 00              and   #$1F
1217 EBDD 8D CC A6              sta   Header.Kind
1218 EBE0              ;
1219 EBE0              ;        move Attribute bits to KIND field
1220 EBE0              ;
1221 EBE0 A3 01                 lda   1,s
1222 EBE2 29 E0 00              and   #$E0
1223 EBE5 E2 30                 sep   #$30
1224 EBE7 8D CD A6              sta   Header.Kind+1
1225 EBEA C2 30                 rep   #$30
1226 EBEC              ;
1227 EBEC              ;        if Absolute Bank Segment, set attribute bit and clear Type
1228 EBEC              ;
1229 EBEC 68                    pla   
1230 EBED 29 1F 00              and   #$1F
1231 EBF0 C9 11 00              cmp   #$11
1232 EBF3 D0 0C                 bne   return
1233 EBF5 AD CC A6              lda   Header.Kind
1234 EBF8 29 E0 FF              and   #$FFE0
1235 EBFB 09 00 08              ora   #AbsBank_Segment
1236 EBFE 8D CC A6              sta   Header.Kind
1237 EC01
1238 EC01 60           return   rts   
1239 EC02
1240 EC02                       ENDP 
